//Program Title: To implement different transforms on given image.
//Program Description: This scilab code is used to implement DCT and DFT transforms on an image and also perform reconstruction of original image using inverse DCT and inverse DFT.

//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit
//Scilab version: 6.0.1 (Tested on 64 bit version)
//Toolbox used: Image Processing and Computer Vision Toolbox (version 2.0)
//Reference book name : Digital Image Processing book (author : Rafael C.Gonzalez and Richard E.Woods)

clear;
clc;
clear all;
close;

img = imread("lena.jpg");
figure(); xname("Original image");
imshow(img);

img_gray = rgb2gray(img);
img_double = im2double(img_gray);

// DCT of image using scilab  function
img_dct = dct(img_double);
figure(); xname("DCT of image using inbuilt function");
imshow(img_dct);


// Creating the Twiddle Factor Matrix c
[m,n]=size(img_gray);
for x=1:m
    for y=1:n
        if x==1  // for row number one
            c(1,y)=sqrt(1/m); 
        else
            c(x,y) = sqrt(2/m)*cos((%pi*(2*y+1)*x)/(2*m));
        end
    end
end

// DCT of image using code
result = c * img_double * c';
figure(); xname("DCT of image using code");
imshow(result);

// Inverse DCT of image using scilab  function
img_idct = idct(img_dct);
figure(); xname("Inverse DCT of image using inbuilt function");
imshow(img_idct);


// Inverse DCT of image using code
result_idct = inv(c) * result* inv(c');
figure(); xname("Inverse DCT of image using code");
imshow(result_idct);

//*******************************************************************************
//DFT
// DFT of image using code
[m,n]=size(img_gray);
for x=1:m
    for y=1:n
        c(x,y) = exp((-2*%i*%pi*((x-1)*(y-1)))/m);
        
    end
end

dft = c * img_double * inv(c);
res=dft;
dft = fftshift(dft);
dft = abs(dft);
figure(); xname("DFT of image using code");
imshow(dft);

//  INVERSE DFT of image using code
idft = inv(c) * res * c ;
res_idft = abs(idft);
figure(); xname("Inverse DFT of image using code");
imshow(res_idft);


